package newstate;

/**
* Transitions are created on the fly and should not be created manually.
*/
class Transition
{
        State target;
        State source;
        
        FSMAction action;
        
        public Transition(State s, State t, FSMAction a)
        {
                source = s;
                target = t;
                action = a;
        }
                
        public void execute(FSMContext fsmc, Object data)
        {
                // trigger a state exit event in the old state
                // execute the action
                source.getStateExitAction().execute(fsmc, data);
                if(action != null)
                        action.execute(fsmc, data);
                fsmc.setState(target);
                target.getStateEntryAction().execute(fsmc, data);
        }
}
